$BuildVer = Get-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows Nt\CurrentVersion'
$Defendersvc = Get-Service | where name -Like *Sense* 
$volumeformat = Get-Volume -DriveLetter C
$SEHOP = Get-ItemProperty -Path 'HKLM:\SYSTEM\CurrentControlSet\Control\Session Manager\kernel'
$credguard = Get-ItemProperty -Path 'HKLM:\SOFTWARE\Policies\Microsoft\Windows\DeviceGuard'
$SolRA = Get-ItemProperty -Path 'HKLM:\Software\Policies\Microsoft\Windows Nt\Terminal Services'
$Autoplay = Get-ItemProperty -Path 'HKLM:\Software\Policies\Microsoft\Windows\Explorer'
$Autos = Get-ItemProperty -Path 'HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Explorer'
$ElevatePriv = Get-ItemProperty -Path 'HKLM:\SOFTWARE\Policies\Microsoft\Windows\Installer'
$WinRM = Get-ItemProperty -Path 'HKLM:\SOFTWARE\Policies\Microsoft\Windows\WinRM\Client'
$WinRMSrv = Get-ItemProperty -Path 'HKLM:\SOFTWARE\Policies\Microsoft\Windows\WinRM\Service'
$RestrictAnon = Get-ItemProperty -Path 'HKLM:\SYSTEM\CurrentControlSet\Control\Lsa'
$NamePipe = Get-ItemProperty -Path 'HKLM:\SYSTEM\CurrentControlSet\Services\LanManServer\Parameters'

$hash = @{ LanManagerHash = $RestrictAnon.NoLMHash;  LanCompLevel = $RestrictAnon.LmCompatibilityLevel; AnonymousNamePipes = $NamePipe.RestrictNullSessAccess; RestrictAnonymous = $RestrictAnon.RestrictAnonymous; RestrictAnonymousSAM = $RestrictAnon.RestrictAnonymousSAM; WinRMSrv = $winRMSrv.AllowBasic; WinRMBasicAuth = $WinRM.AllowBasic; WindowsInstaller = $ElevatePriv.AlwaysInstallElevated; Autorun = $autos.NoAutorun; AutoplayNonVolume = $autoplay.NoAutoplayfornonVolume; AutoplayDisabled = $autos.NoDriveTypeAutoRun; CurrentBuildNumber = $buildver.CurrentBuildNumber; MSSenseRunning = $Defendersvc.Status; VolumeFormat = $volumeformat.FileSystem; SEHOP = $SEHOP.DisableExceptionChainValidation; DeviceGuard = $credguard.LsaCfgFlags; SolicateRemoteAssistance = $SolRA.fAllowToGetHelp}
return $hash | ConvertTo-Json -Compress